function [] = plotheatmapfunction(figuretitle1,figuretitle2,xlabel1,ylabel1,xlabel2,ylabel2,timetraces,xaxis)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% INPUT ARGUMENTS:

%%% Example of a string: 'MFI/MFI_{0} of single cells'

%%% figuretitle1 : title of first plot, string 
%%% figuretitle2 : title of heatmap plot, string 
%%% xlabel1 : title of x-axis in first plot, string 
%%% ylabel1 : title of y-axis in first plot, string 
%%% xlabel2 : title of x-axis in heatmap plot, string 
%%% ylabel2 : title of y-axis in heatmap plot, string 
%%% timetraces : timetraces matrix to plot (each col is a cell)
%%% xaxis : row containing x-axis labels (actual times)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ntraces = length(timetraces(1,:));

figure('Name','Plot and Heatmap','NumberTitle','off','Color',[1 1 1])
ii=0;
for ii=1:ntraces
    subplot(2,1,1)
    plot(xaxis,timetraces(:,ii));
    hold on
end
title(figuretitle1,'FontSize',20,'FontName','Optima');
xlabel(xlabel1,'FontSize',18,'FontName','Optima');
ylabel(ylabel1,'FontSize',18,'FontName','Optima');
xlim([min(xaxis) max(xaxis)]);

xxlabel = [1:length(timetraces(:,1))];

subplot(2,1,2)
imagesc(timetraces')
title(figuretitle2,'FontSize',20,'FontName','Optima');
xlabel(xlabel2,'FontSize',18,'FontName','Optima');
ylabel(ylabel2,'FontSize',18,'FontName','Optima');
xlim([min(xxlabel) max(xxlabel)]);

%%% saves figure

if(exist('figdir','var') == 1)
    saveFigs(figdir,'format','png','name','measurement');
else
    saveFigs('img','format','jpg','name','measurement');
end

end


